require 'g_level'
g_level.reset()

--INIT TEXTURES  -- adds a texture into ObjectManager<Texture>
h = FM_NEAREST;
lua_init_texture("bar_background", "data/images/lvl_bar/baari.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("stairs", "data/images/lvl_bar/baari-rappuset.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("gayhorse", "data/images/lvl_bar/homo_heppa_32.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)
lua_init_texture("dwarf", "data/images/lvl_bar/kaapio_vampyyri.png", h, WM_REPEAT,WM_CLAMP,AM_MODULATE)

-- Create Level
lua:create_level(1.0,1.0,1.0,1.0)   --RGBA values are given also

-- Create Layers
-- The index of the layers are auto incremented. This meaning that the first one to add is 0 and rest are in order of appearance...
lua:create_layer(1.0,1.0,BM_DEFAULT)  -- x_scroll , y_scroll, blendmode  -- 0
lua:create_layer(1.0,1.0,BM_DEFAULT) -- 1
lua:create_layer(1.0,1.0,BM_DEFAULT) -- 2
lua:create_layer(0.0,0.0,BM_DEFAULT) -- 3 --dummy

-- Background starts
local scale = 0.75
lua:create_sprite("background", ST_TEXTURED,"bar_background",      0.0, 0.0) 
lua:sprite_shape("background",ST_TEXTURED,                          scale * 2048.0/2, scale * 1024.0/2)
lua:textured_sprite_tex_coords("background", ST_TEXTURED,           0.0, 0.0, 1.0, 1.0)
g_level.upload("background",                                         0)
-- Background ends

local scale = 0.75
lua:create_sprite("stairs", ST_TEXTURED,"stairs",                   -375.0, 0.0) 
lua:sprite_shape("stairs",ST_TEXTURED,                              scale * 1024.0/2, scale * 1024.0/2)
lua:textured_sprite_tex_coords("stairs", ST_TEXTURED,               0.0, 0.0, 1.0, 1.0)
g_level.upload("stairs",                                            2)

local scale = 0.16
lua:create_sprite("gay", ST_TEXTURED,"gayhorse",                   -115.0, -30.0) 
lua:sprite_shape("gay",ST_TEXTURED,                              scale * 1024.0/2, scale * 1024.0/2)
lua:textured_sprite_tex_coords("gay", ST_TEXTURED,               1.0, 0.0, 0.0, 1.0)
g_level.upload("gay",                                            1)

local scale = 0.25
lua:create_sprite("dwarf", ST_TEXTURED,"dwarf",                   150.0, -50.0) 
lua:sprite_shape("dwarf",ST_TEXTURED,                              scale * 720.0/2, scale * 720.0/2)
lua:textured_sprite_tex_coords("dwarf", ST_TEXTURED,               0.0, 0.0, 1.0, 1.0)
g_level.upload("dwarf",                                            1)

--segments
lua:create_segment(-1345, -140)
lua:add_segment(4095, -140)
lua:upload_segmentstrip()


--colliders
--left infinite stopper
stopper(RIGHT,400.0)
--bar table infinite stopper
stopper(LEFT,-500.0)


--init dialog globals
lua:do_file("data/scripts/srt_bartender_dialog_switch.lua")
lua:do_file("data/scripts/srt_dwarf_dialog_switch.lua")
lua:do_file("data/scripts/srt_unicorn_dialog_switch.lua")

--triggers
--bartender
switch("data/scripts/srt_bartender_dialog_switch.lua",350.0,-100.0) --script,x,yx
--dwarf
switch("data/scripts/srt_dwarf_dialog_switch.lua",140.0,-50.0) --script,x,y
--highlight(-100.0,-30.0,100.0,100.0,1) --x,y,offset in vertical axis, radius, layer
--gayhorse
switch("data/scripts/srt_unicorn_dialog_switch.lua",-115.0,-30.0) --script,x,y
--door
--switch_adv("data/scripts/srt_next_level.lua",-475.0,-100.0,150.0,0)
trigger("data/scripts/srt_next_level.lua","",20,50,-480,0) --in,out,w,h,x,y

--Player
--INIT PLAYER
lua:do_file("data/scripts/crt_player_trigger.lua",0)
lua:init_camera_binder(-720.0, 720.0, -350.0, 350.0) -- left, right, bottom, up
lua:upload_player_to_layer(1)  --index of the layer
lua:creature_translation("player", CPT_PLAYER, -400.0, 160.0) -- set the player to it's right position
--Player end

lua:set_game_state(GS_PLAY) -- sets the game state to menu. thus you are able to use the menu commands
g_level.next_level = "data/scripts/lvl_city.lua"

